unit f_Report;

interface

uses
  Windows, Messages, SysUtils, Classes, Graphics, Controls, Forms, Dialogs,
  uAbstractAppConfig, uAppConfig, uCustomAIMFactoryConfig,
  uCommonAIMFactoryConfig, uAIMFactoryConfig, uCustomReportFactory,
  uReportFactory, uReport, comctrls, stdctrls, extctrls;

type
  TRiskObj = class(TComponent)
  private
    FBeta: double;
    FSharpRatio: double;
    FTotalRisk: double;
  published
    property SharpRatio: double read FSharpRatio write FSharpRatio;
    property TotalRisk: double read FTotalRisk write FTotalRisk;
    property Beta: double read FBeta write FBeta;
  end;

  TValueObj = class(TComponent)
  private
    FValue: integer;
    FDifference: integer;
    FProductID: string;
  public
    constructor CreateValue(AOwner: TComponent; AValue: integer);
  published
    property Value: integer read FValue write FValue;
    property Difference: integer read FDifference write FDifference;
    property ProductID: string read FProductID write FProductID;
  end;

  TItemList = class(TList)
  private
    FCaption: string;
  public
    constructor CreateItem(ACaption: string);
  published
    property Caption: string read FCaption write FCaption;
  end;

  TCustomObj = class(TComponent)
  private
    FList: TList;
  published
    property ObjList: TList read FList write FList;
  end;

  TfmReport = class(TForm)
    AIMFactoryConfig1: TAIMFactoryConfig;
    ReportFactory1: TReportFactory;
    procedure ReportFactory1ReportDragOver(Sender, Source: TObject;
      ADOESenderType: TDOESenderType; X, Y: Integer;
      var AObjProperties: TReportObjectProperties);
  private
    FCustomObj: TCustomObj;
    FRisk: array[0..3] of TRiskObj;
    function getCorrectObject(ATV: TTreeView): TObject;
  public
    constructor Create(AOwner: TComponent); override;
  end;

var
  fmReport: TfmReport;

implementation

{$R *.DFM}

constructor TValueObj.CreateValue(AOwner: TComponent; AValue: integer);
var p: integer;

begin
  inherited Create(AOwner);
  FValue := AValue;
  FDifference := random(200) - 100;
  FProductID := '';
  for p := 0 to 10 do
    FProductID := FProductID + chr(ord('0') + random(10));
end;

constructor TItemList.CreateItem(ACaption: string);
begin
  inherited Create;
  FCaption := ACaption;
end;

function TfmReport.getCorrectObject(ATV: TTreeView): TObject;
  procedure parseObj(ATN: TTreeNode; AList: TList); overload;
  var lT: TTreeNode;
  begin
    lT := ATN.getFirstChild;
    while lT <> nil do
    begin
      if lT.getFirstChild = nil then
        AList.Add(TValueObj.CreateValue(self, StrToIntDef(lT.Text, 0)))
      else
      begin
        AList.Add(TItemList.CreateItem(lT.Text));
        parseObj(lT, TItemList(AList.Last));
      end;
      lT := ATN.GetNextChild(lT);
    end;
  end;
  procedure parseObj(ATN: TTreeNodes; AList: TList); overload;
  var p: integer;
  begin
    for p := 0 to ATN.Count - 1 do
      if ATN.Item[p].Level = 0 then
      begin
        AList.Add(TItemList.CreateItem(ATN.Item[p].Text));
        parseObj(ATN.Item[p], TItemList(AList.Last));
      end;
  end;
begin
  FCustomObj.ObjList.Clear;
  parseObj(ATV.Items, FCustomObj.ObjList);
  Result := FCustomObj;
end;

constructor TfmReport.Create(AOwner: TComponent);
begin
  inherited;

  FCustomObj := TCustomObj.Create(self);
  FCustomObj.ObjList := TList.Create;
  FRisk[0] := TRiskObj.Create(self);
  FRisk[0].Name := 'EURO';
  FRisk[0].SharpRatio := -0.206;
  FRisk[0].TotalRisk := 0.039;
  FRisk[0].Beta := 0.173;

  FRisk[1] := TRiskObj.Create(self);
  FRisk[1].Name := 'PFUNDSTERLING';
  FRisk[1].SharpRatio := 0.365;
  FRisk[1].TotalRisk := 0.078;
  FRisk[1].Beta := 0.453;

  FRisk[2] := TRiskObj.Create(self);
  FRisk[2].Name := 'SCHWEDISCHEKRONE';
  FRisk[2].SharpRatio := 0.112;
  FRisk[2].TotalRisk := 0.075;
  FRisk[2].Beta := -0.409;

  FRisk[3] := TRiskObj.Create(self);
  FRisk[3].Name := 'SPANISCHEPESETA';
  FRisk[3].SharpRatio := -0.275;
  FRisk[3].TotalRisk := 0.037;
  FRisk[3].Beta := 0.198;
end;

procedure TfmReport.ReportFactory1ReportDragOver(Sender, Source: TObject;
  ADOESenderType: TDOESenderType; X, Y: Integer;
  var AObjProperties: TReportObjectProperties);
begin
  with AObjProperties do
    if ADOESenderType = doeReport then
    begin
      if ObjPtr is TTreeView then
      begin
        ObjPtr := getCorrectObject(TTreeView(ObjPtr));
        if ObjPtr is TComponent then
          ObjCaption := TComponent(ObjPtr).Name;
      end
      else
        if ObjPtr is TListBox then
        begin
          ObjPtr := FRisk[TListBox(ObjPtr).Tag mod 4];
          if ObjPtr is TComponent then
            ObjCaption := TComponent(ObjPtr).Name;
        end;
    end
end;

end.

